local super = require "Control"

ReorderThumb = super:new()

function ReorderThumb:new()
    self = super.new(self)
    
    self._hover = false
    
    return self
end

function ReorderThumb:draw(canvas)
    local rect = self:rect()
    local size = 3
    local spacing = 5
    local cx, cy = canvas:metrics():alignToPixelCenter(rect:midx(), rect:midy())
    
    canvas:setPaint(self:fillPaint())
        :fill(Path.rect{ left = cx - size / 2, bottom = cy - spacing - size / 2, right = cx + size / 2, top = cy - spacing + size / 2 })
        :fill(Path.rect{ left = cx - size / 2, bottom = cy - size / 2, right = cx + size / 2, top = cy + size / 2 })
        :fill(Path.rect{ left = cx - size / 2, bottom = cy + spacing - size / 2, right = cx + size / 2, top = cy + spacing + size / 2 })
end

function ReorderThumb:fillPaint()
    if self:isActive() and self:getProperty('enabled') then
        if self._hover then
            return Color.gray(0, 0.3)
        else
            return Color.gray(0, 0.15)
        end
    else
        return Color.gray(0, 0.08)
    end
end

function ReorderThumb:move(x, y)
    local hover = self:rect():contains(x, y)
    if hover ~= self._hover then
        self._hover = hover
        self:invalidate()
    end
end

function ReorderThumb:up()
    if self._hover then
        self._hover = false
        self:invalidate()
    end
end

return ReorderThumb
